/// <reference path="./typings.d.ts"/>
import {ThemeProvider} from "@yandex-infracloud-ui/common";
import moment from "moment";
import React from "react";
import ReactDOM from "react-dom";
import {BehaviorSubject} from "rxjs";
import {BrowserRouter, Route} from "react-router-dom";
import {QueryParamProvider} from "use-query-params";

import {App} from "./_layout/App/App";
import '@yandex-data-ui/common/styles/styles.scss';
import "./design/index.css";

import {ApiServices, ApiServicesContext, Config, ConfigContext} from "./services";

import * as serviceWorker from "./serviceWorker";

const config = new Config(window.YC);
const apiServices = new ApiServices(config);
const newVersion = new BehaviorSubject<boolean>(false);

moment.locale("en");
console.log("Config is", config);

ReactDOM.render(
    <ConfigContext.Provider value={config}>
        <BrowserRouter basename={process.env.PUBLIC_URL}>
            <QueryParamProvider ReactRouterRoute={Route}>
                <ApiServicesContext.Provider value={apiServices}>
                    <ThemeProvider theme="light">
                        <App user={config.getUser()} newVersion={newVersion} />
                    </ThemeProvider>
                </ApiServicesContext.Provider>
            </QueryParamProvider>
        </BrowserRouter>
    </ConfigContext.Provider>,
    document.getElementById("root")
);

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: https://bit.ly/CRA-PWA
serviceWorker.unregister();
