import block from "bem-cn-lite";
import PropTypes from "prop-types";
import React, {Component} from "react";
import {withRouter} from "react-router-dom";

import RouteLink from "../RouteLink/RouteLink";

import "./NavigationTabs.scss";

const b = block("navigation-tabs");

class NavigationTabs extends Component {
    static propTypes = {
        location: PropTypes.object.isRequired,
        tabs: PropTypes.arrayOf(
            PropTypes.shape({
                id: PropTypes.string,
                title: PropTypes.string.isRequired,
                titleMark: PropTypes.node,
            })
        ).isRequired,
        className: PropTypes.string,
    };

    renderTab = (tab, index) => {
        const {location} = this.props;
        const currentParams = new URLSearchParams(location.search);
        const activeTabId = currentParams.get("tab");
        const isFirstTab = index === 0;
        let isActive = activeTabId === tab.id || (isFirstTab && !activeTabId);
        if (tab.path) {
            if (typeof tab.path === "string") {
                if (isFirstTab) {
                    isActive = isFirstTab && window.location.pathname === tab.path;
                } else {
                    isActive = window.location.pathname.indexOf(tab.path) >= 0;
                }
            } else {
                const {match} = tab.path;
                isActive = match.some(({predicate, strict}) => {
                    if (strict) {
                        return window.location.pathname === predicate;
                    } else {
                        return window.location.pathname.includes(predicate);
                    }
                });
            }
        }

        if (isFirstTab) {
            currentParams.delete("tab");
        } else {
            currentParams.set("tab", tab.id);
        }

        let url;
        if (tab.path) {
            if (typeof tab.path === "object") {
                url = tab.path.url;
            } else {
                url = tab.path;
            }
        } else {
            url = {...location, search: currentParams.toString()};
        }

        return (
            <div
                className={b("tab", {active: isActive})}
                aria-selected={isActive}
                role="tab"
                key={index}
                data-test={`navigation-tabs--${tab.title.split(" ").join("-").toLowerCase()}`}
            >
                <RouteLink to={url} theme="normal" mix={{block: b("tab-link")}} disabled={tab.isDisabled}>
                    {tab.title}
                    {tab.titleMark || null}
                </RouteLink>
            </div>
        );
    };

    render() {
        const {tabs, className} = this.props;

        return (
            <div className={`${b()} ${className}`} role="tablist" data-test="navigation-tabs">
                {tabs.map(this.renderTab)}
            </div>
        );
    }
}

export default withRouter(NavigationTabs);
