import React from "react";

import {AppRouteProps} from "../models";
import {EventsPage} from "./events";
import {SessionPage} from "./session";
import {MonitoringPage} from "./monitoring";

export const ROUTES: AppRouteProps[] = [
    {path: "/", component: EventsPage, exact: true},
    {path: "/session", component: () => (<SessionPage isSaved={false}/>), exact: true},
    {path: "/saved-session", component: () => (<SessionPage isSaved={true}/>), exact: true},
    {path: "/monitoring", component: MonitoringPage, exact: true},
];
