import React, {useContext} from "react";

import {ApiServiceName} from "../../models";
import {Config} from "../Config";

import {GideonApi} from "./GideonApi";

export class ApiServices {
    public gideon: GideonApi;

    constructor(config: Config) {
        this.gideon = new GideonApi(config.getApiEndpointForService(ApiServiceName.Gideon));
    }
}

export const ApiServicesContext = React.createContext<ApiServices | null>(null);

export function useGideonApi() {
    const api = useContext(ApiServicesContext);
    if (api === null) {
        throw new Error("you must define value for ApiServicesContext");
    }

    return api.gideon;
}
