interface ClusterConfig {
    title: string;
    value: string;
}

interface EnvConfig {
    authorizePath: string;
    avatarHost: string;
    blackboxHost: string;
    clusters: ClusterConfig[];
    deployEngine: string;
    deployRobots: string[];
    envName: string;
    feedbackFormId: number | null;
    nannyUiDomain: string;
    passportHost: string;
    resignPath: string;
    sentryDsn: string | null;
    idmSystemName: string;
    serviceWorkerRefreshIntervalMinutes: number;
    services: {
        name: string;
        endpoint: string;
    }[];
    yasmPush: string;
    clck: string;
}

interface YandexConfig {
    __api: any;
    __notifications: any;
    envConfig: EnvConfig;
    metrika: string;
    now: string;
    user: {uid: string; login: string};
    version: string;
}

interface Window {
    /**
     * Лучше не использовать напрямую из window, есть обёртка Config.
     *
     * Конфиг можно получить из контекста ConfigContext или хука useConfig()
     *
     * @deprecated
     */
    YC: YandexConfig;
}

declare module "@yandex-data-ui/infra-buzzer" {
    import * as React from "react";
    import {Store} from "redux";

    export const store: Store;

    export const PRODUCTION: string;

    export const TESTING: string;

    interface ISubscription {
        environmentId?: number;
        serviceId: number;
    }

    interface InfraBuzzerProps {
        environment: string;
        subscribeTo: ISubscription[];
    }

    export class InfraBuzzer extends React.Component<InfraBuzzerProps> {}

    export function infraBuzzer(): void;
}

// tslint:disable-next-line:no-namespace
declare module "react-json-syntax-highlighter" {
    import * as React from "react";

    interface ReactJsonSyntaxHighlighterProps {
        /**
         * фейковый props для использования CSS Modules
         */
        cls?: string;
        obj: any;
    }

    // tslint:disable-next-line:max-classes-per-file
    export default class ReactJsonSyntaxHighlighter extends React.Component<ReactJsonSyntaxHighlighterProps> {}
}

declare module "json-to-pretty-yaml" {
    const YAML: {
        stringify: (obj: any) => string;
    };

    export = YAML;
}
