import {useEffect, useRef} from "react";

export function useTitle(title: string, deps?: any[]) {
    if (deps === undefined) {
        deps = [];
    }

    const previousTitle = useRef(document.title);

    useEffect(() => {
        previousTitle.current = document.title;

        document.title = title ? `Gideon: ${title}` : "Gideon";

        return () => {
            if (previousTitle.current) {
                document.title = previousTitle.current;
            } else {
                document.title = "Gideon";
            }
        };
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [...deps, title]);
}
