package anytime

import (
	"errors"
	"time"
)

var errInvalidTimeFormat = errors.New("invalid time format")

func Parse(s string) (int64, error) {
	if t, err := ParseUnix(s); err == nil {
		return t.UnixNano(), nil
	}

	if t, err := ParseTime(s); err == nil {
		return t.UnixNano(), nil
	}

	if d, err := ParseDuration(s); err == nil {
		return time.Now().Add(d).UnixNano(), nil
	}

	return 0, errInvalidTimeFormat
}
