package anytime

import "time"

var allowedTimestampFormats = []string{
	"2006-01-02T15:04:05",
	"2006-01-02T15:04",
	"2006-01-02T15",
	"2006-01-02",
}

var defaultLocation = func() *time.Location {
	l, err := time.LoadLocation("Europe/Moscow")
	if err != nil {
		panic(err)
	}

	return l
}()

func ParseTime(s string) (time.Time, error) {
	// Quick check: all date formats start with YYYY-.
	i := 0
	for ; i < len(s); i++ {
		if c := s[i]; c < '0' || c > '9' {
			break
		}
	}
	if i != 4 || i == len(s) || s[i] != '-' {
		return time.Time{}, errInvalidTimeFormat
	}

	if t, err := time.Parse("2006-01-02T15:04:05MST", s); err == nil {
		return t, nil
	}

	for _, format := range allowedTimestampFormats {
		if t, err := time.ParseInLocation(format, s, defaultLocation); err == nil {
			return t, nil
		}
	}

	return time.Time{}, errInvalidTimeFormat
}
