package anytime

import (
	"errors"
	"strconv"
	"time"
)

var errNotUnixTimestamp = errors.New("not a unix timestamp")

func ParseUnix(s string) (time.Time, error) {
	if len(s) != 10 {
		return time.Time{}, errNotUnixTimestamp
	}

	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		return time.Time{}, err
	}

	return time.Unix(i, 0), nil
}
