package masker

import (
	"context"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"

	"github.com/go-resty/resty/v2"
)

type Masker struct {
	httpc *resty.Client
}

func NewMasker(upstream string) *Masker {
	return &Masker{
		httpc: resty.New().
			SetBaseURL(upstream).
			SetDoNotParseResponse(true),
	}
}

func (m *Masker) Mask(ctx context.Context, in []byte) ([]byte, error) {
	rsp, err := m.httpc.R().
		SetContext(ctx).
		SetBody(in).
		Post("/mask")

	if err != nil {
		return nil, fmt.Errorf("failed to call masker: %w", err)
	}

	body := rsp.RawBody()
	defer func() {
		_, _ = io.CopyN(ioutil.Discard, body, 128<<10)
		_ = body.Close()
	}()

	switch rsp.StatusCode() {
	case http.StatusOK:
		out, err := ioutil.ReadAll(body)
		if err != nil {
			return nil, fmt.Errorf("failed to read response: %w", err)
		}

		return out, nil
	case http.StatusNoContent:
		return in, nil
	default:
		return nil, fmt.Errorf("non-success response: %s", rsp.Status())
	}
}
