package models

import "a.yandex-team.ru/security/gideon/gideon/pkg/events"

//go:generate easyjson

//easyjson:json
type JsEvent struct {
	TS     uint64           `json:"ts"`
	Kind   events.EventKind `json:"kind"`
	Source string           `json:"source"`
	Host   string           `json:"host"`
	Proc   struct {
		Pid            uint32 `json:"pid"`
		Name           string `json:"name"`
		Ppid           uint32 `json:"ppid"`
		ParentName     string `json:"parent_name"`
		UID            uint32 `json:"uid"`
		SessionID      uint32 `json:"session_id,omitempty"`
		Container      string `json:"container,omitempty"`
		PodID          string `json:"pod_id,omitempty"`
		PodSetID       string `json:"podset_id,omitempty"`
		NannyServiceID string `json:"nanny_service_id,omitempty"`
	} `json:"proc,omitempty"`
	ProcExec struct {
		Exe  string   `json:"exe,omitempty"`
		Args []string `json:"args,omitempty"`
	} `json:"proc_exec,omitempty"`
	Ptrace struct {
		RetCode int64 `json:"ret_code,omitempty"`
		Request int64 `json:"request,omitempty"`
		Target  int32 `json:"target,omitempty"`
	} `json:"ptrace,omitempty"`
	Connect struct {
		DstAddr string                   `json:"dst_addr,omitempty"`
		DstPort uint32                   `json:"dst_port,omitempty"`
		Family  events.AddressFamilyKind `json:"family,omitempty"`
	} `json:"connect,omitempty"`
	SSHSession struct {
		ID   string             `json:"id,omitempty"`
		User string             `json:"user,omitempty"`
		TTY  string             `json:"tty,omitempty"`
		Kind events.SessionKind `json:"kind"`
	} `json:"ssh_session,omitempty"`
	OpenAt struct {
		RetCode  int64  `json:"ret_code,omitempty"`
		FD       int64  `json:"fd,omitempty"`
		Filename string `json:"filename,omitempty"`
		Flags    int32  `json:"flags,omitempty"`
	} `json:"open_at,omitempty"`
}
