package models

//go:generate easyjson

//easyjson:json
type SSHSessionInfo struct {
	TS        uint64
	Host      string
	PodID     string
	SessionID uint32
}

func SSHSessionInfoFromEvent(event JsEvent) SSHSessionInfo {
	return SSHSessionInfo{
		TS:        event.TS,
		Host:      event.Host,
		PodID:     event.Proc.PodID,
		SessionID: event.Proc.SessionID,
	}
}
