package export

import (
	"context"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/yt/go/ypath"
	"a.yandex-team.ru/yt/go/yt"
)

type Meta struct {
	LastSync int64 `yson:"last_sync"`
}

func (a *App) metaPath() ypath.Path {
	return ypath.Path(a.cfg.YT.Path).JoinChild("export-meta")
}

func (a *App) createMeta() (*Meta, error) {
	return &Meta{
		LastSync: time.Now().UnixNano(),
	}, nil
}

func (a *App) restoreMeta() (*Meta, error) {
	var meta Meta
	err := a.yt.GetNode(context.Background(), a.metaPath(), &meta, nil)
	if err == nil {
		return &meta, nil
	}

	a.log.Error("failed to restore meta from YT, create new one", log.Error(err))
	return a.createMeta()
}

func (a *App) saveMeta(meta *Meta) error {
	return a.yt.SetNode(context.Background(), a.metaPath(), meta, &yt.SetNodeOptions{Force: true})
}
