package www

import (
	"encoding/json"

	"a.yandex-team.ru/security/gideon/viewer/internal/filter"
	"a.yandex-team.ru/security/gideon/viewer/internal/models"
)

//go:generate easyjson

//easyjson:json
type queryRequest struct {
	Filter filter.Filter `json:"filter"`
}

//easyjson:json
type queryResponse struct {
	Ok     bool             `json:"ok"`
	Events []models.JsEvent `json:"events"`
}

//easyjson:json
type gewSessionRequest struct {
	Key string `json:"key"`
}

//easyjson:json
type getSessionResponse struct {
	Ok     bool             `json:"ok"`
	Events []models.JsEvent `json:"events"`
}

//easyjson:json
type getSavedSessionRequest struct {
	Key string `json:"key"`
}

//easyjson:json
type getSavedSessionResponse struct {
	Ok     bool            `json:"ok"`
	Events json.RawMessage `json:"events"`
}

//easyjson:json
type newSessionRequest struct {
	TS           uint64 `json:"time"`
	SSHSessionID string `json:"ssh_session_id"`
	SessionID    uint32 `json:"gideon_session_id"`
}

//easyjson:json
type newSessionResponse struct {
	Ok    bool   `json:"ok"`
	Key   string `json:"key"`
	URL   string `json:"url"`
	Title string `json:"title"`
}

//easyjson:json
type suggestRequest struct {
	FullSearch  bool          `json:"fullSearch"`
	ValuePrefix string        `json:"valuePrefix"`
	Key         string        `json:"key"`
	Filter      filter.Filter `json:"filter"`
}

//easyjson:json
type suggestResponse struct {
	Ok     bool     `json:"ok"`
	Values []string `json:"values"`
}

//easyjson:json
type errResponse struct {
	Ok  bool   `json:"ok"`
	Err string `json:"error"`
}
