package sessionstorage

import (
	"errors"

	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/service/s3"
)

const (
	ErrCodeBucketAlreadyExists            = s3.ErrCodeBucketAlreadyExists
	ErrCodeBucketAlreadyOwnedByYou        = s3.ErrCodeBucketAlreadyOwnedByYou
	ErrCodeInvalidObjectState             = s3.ErrCodeInvalidObjectState
	ErrCodeNoSuchBucket                   = s3.ErrCodeNoSuchBucket
	ErrCodeNoSuchKey                      = s3.ErrCodeNoSuchKey
	ErrCodeNoSuchUpload                   = s3.ErrCodeNoSuchUpload
	ErrCodeObjectAlreadyInActiveTierError = s3.ErrCodeObjectAlreadyInActiveTierError
	ErrCodeObjectNotInActiveTierError     = s3.ErrCodeObjectNotInActiveTierError
)

func IsErrCode(err error, code string) bool {
	var awsErr awserr.Error
	return errors.As(err, &awsErr) && awsErr.Code() == code
}
