package cli

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/hector/internal/config"
	"a.yandex-team.ru/security/hector/internal/state"
)

type CheckCommandFn func(oldState *state.RepoState, newState *state.RepoState) (err error)

func WrapCobraCommand(repoName string, command CheckCommandFn) func(cmd *cobra.Command, args []string) error {
	return func(cmd *cobra.Command, args []string) (err error) {
		var hectorState *state.State
		var repoState *state.RepoState
		if config.StateIn != "" && isFileExists(config.StateIn) {
			hectorState, err = state.Load(config.StateIn)
			if err != nil {
				return fmt.Errorf("failed to load state: %s", err.Error())
			}
		} else {
			hectorState = state.NewState()
		}

		if config.StateOut != "" {
			repoState = state.NewRepoState()
		}

		err = command(hectorState.GetRepoState(repoName), repoState)
		if err != nil {
			return
		}

		if config.StateOut != "" {
			hectorState.ReposInfo[repoName] = repoState
			err = state.Save(config.StateOut, hectorState)
		}
		return
	}
}

func isFileExists(filePath string) bool {
	_, err := os.Stat(filePath)
	return err == nil
}
