package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/buildinfo"
	"a.yandex-team.ru/security/hector/internal/config"
)

var versionCmd = &cobra.Command{
	Use:   "version",
	Short: "show the current version",
	Run: func(cmd *cobra.Command, args []string) {
		fmt.Printf("Version: %s\n", config.FullVersion())
		fmt.Println(buildinfo.Info.ProgramVersion)
	},
}

func init() {
	RootCmd.AddCommand(versionCmd)
}
