package fsutils

import (
	"fmt"
	"os"
)

func IsDirExists(path string) bool {
	if stat, err := os.Stat(path); err == nil {
		return stat.IsDir()
	}
	return false
}

func DirMustExists(path string) error {
	if stat, err := os.Stat(path); err == nil {
		if stat.IsDir() {
			return nil
		}
		return fmt.Errorf("%s is not a directory", path)
	}
	return os.MkdirAll(path, 0755)
}
