package gitlab

import "time"

const (
	VisibilityPublic   = "public"
	VisibilityPrivate  = "private"
	VisibilityInternal = "internal"
)

type (
	RepoWalkFn func(project Project) (next bool)

	Project struct {
		Repository
		Visibility string     `json:"visibility"`
		ForkOf     Repository `json:"forked_from_project"`
	}

	Repository struct {
		ID       int    `json:"id"`
		Name     string `json:"path_with_namespace"`
		SSHRepo  string `json:"ssh_url_to_repo"`
		HTTPRepo string `json:"http_url_to_repo"`
		UIRepo   string `json:"web_url"`
	}

	Clone struct {
		HREF string `json:"href"`
		Name string `json:"name"`
	}

	Self struct {
		HREF string `json:"href"`
	}

	Ref struct {
		DisplayID string `json:"displayId"`
	}

	Commit struct {
		ID           string    `json:"id"`
		AuthorName   string    `json:"author_name"`
		AuthorEmail  string    `json:"author_email"`
		AuthoredDate time.Time `json:"authored_date"`
	}
)
