package remote

type Repo interface {
	Name() string
	Parent() string
	ProjectURL() string
	CloneURL() string
	PathToURL(relativePath string, lineNo int) string
	Checkout(target string, shallow bool) (skip bool, err error)
	Owners() (owners []string, err error)
	Author(relativePath string, lineNo int) (author string, err error)
	GenResultPath(resultDir string) string
	GenLocalPath(workDir string) string
	Reference() string
	Export() ExportedRepo
}

type ExportedRepo struct {
	Name       string   `json:"name,omitempty"`
	Parent     string   `json:"parent,omitempty"`
	ProjectURL string   `json:"url,omitempty"`
	CloneURL   string   `json:"clone_url,omitempty"`
	Owners     []string `json:"owners,omitempty"`
	Reference  string   `json:"reference,omitempty"`
	Private    bool     `json:"private"`
}
