package config

import (
	"time"

	"a.yandex-team.ru/security/impulse/api/internal/db"
)

type (
	Config struct {
		UpstreamURL string
		DBConn      string
		DBPassword  string
		DBRetries   int
		HTTPPort    uint32
		UseAuth     bool
		Debug       bool
	}
)

func (c *Config) DBConfig() *db.Options {
	return &db.Options{
		DSN:             c.DBConn,
		Password:        c.DBPassword,
		QueryRetries:    c.DBRetries,
		MaxOpenConns:    10,
		MaxIdleConns:    2,
		ConnMaxLifetime: time.Hour,
	}
}
