package infra

import (
	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
	"a.yandex-team.ru/security/impulse/api/codeql-api/internal/config"
	"a.yandex-team.ru/security/impulse/api/internal/db"
)

type Infra struct {
	CFG      config.Config
	DB       *db.DB
	TVM      *tvmtool.Client
	BlackBox blackbox.Client
}

func New(cfg config.Config) *Infra {
	return &Infra{
		CFG: cfg,
	}
}

func (c *Infra) Start() (err error) {
	if c.CFG.UseAuth {
		c.TVM, err = tvmtool.NewAnyClient()
		if err != nil {
			return
		}

		c.BlackBox, err = httpbb.NewIntranet(httpbb.WithTVM(c.TVM))
		if err != nil {
			return err
		}
	}

	c.DB, err = db.New(c.CFG.DBConfig())
	if err != nil {
		return err
	}
	err = c.DB.InitSchema()
	if err != nil {
		return err
	}

	return nil
}

func (c *Infra) Done() (err error) {
	return nil
}
