package access

import (
	"strconv"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/impulse/api/internal/user"
	"a.yandex-team.ru/security/impulse/api/internal/utils"
)

func WithRole(minRole string) echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(e echo.Context) error {
			if user.HasAccessToOrganization(e, 0, minRole) {
				return next(e)
			}

			return utils.APIForbidden(e)
		}
	}
}

func WithRoleInOrganization(minRole string) echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(e echo.Context) error {
			orgID, err := strconv.Atoi(e.Param("organizationId"))
			if err != nil {
				return utils.APIForbidden(e)
			}

			if user.HasAccessToOrganization(e, orgID, minRole) {
				return next(e)
			}

			return utils.APIForbidden(e)
		}
	}
}

func WithAnyRoleInOrganization(next echo.HandlerFunc) echo.HandlerFunc {
	return func(e echo.Context) error {
		orgID, err := strconv.Atoi(e.Param("organizationId"))
		if err != nil {
			return utils.APIForbidden(e)
		}

		if user.HasAccessToAnyProject(e, orgID) {
			return next(e)
		}

		return utils.APIForbidden(e)
	}
}

func WithRoleInProject(minRole string) echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(e echo.Context) error {
			orgID, err := strconv.Atoi(e.Param("organizationId"))
			if err != nil {
				return utils.APIForbidden(e)
			}
			projID, err := strconv.Atoi(e.Param("projectId"))
			if err != nil {
				return utils.APIForbidden(e)
			}

			if user.HasAccessToProject(e, orgID, projID, minRole) {
				return next(e)
			}

			return utils.APIForbidden(e)
		}
	}
}
