package tvm

import (
	"github.com/labstack/echo/v4"
	"golang.org/x/xerrors"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
	"a.yandex-team.ru/security/impulse/api/internal/utils"
)

func WithTVM(tvm *tvmtool.Client, srcTvmID tvm.ClientID) echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(e echo.Context) error {
			serviceTicket := e.Request().Header.Get("X-Ya-Service-Ticket")
			if serviceTicket == "" {
				return utils.APIForbidden(e)
			}

			ticketInfo, err := tvm.CheckServiceTicket(e.Request().Context(), serviceTicket)
			if err != nil {
				return utils.APIError(e, xerrors.Errorf("failed to check TVM ticket: %w", err))
			}

			if srcTvmID == ticketInfo.SrcID {
				return next(e)
			}

			return utils.APIForbidden(e)
		}
	}
}
