package sandbox

import (
	"a.yandex-team.ru/security/impulse/models"
)

type (
	API interface {
		Close() error
		CreateTask(taskMessage *models.TaskMessageDTO, needDNS64 bool) (int, error)
		CreateBuildCodeQLTask(organizationID, projectID int, repositoryURL string) (int, error)
		StartTask(sandboxTaskID int) error
	}

	Options struct {
		Endpoint   string
		OAuthToken string
	}

	TaskPriority struct {
		Class    string `json:"class"`
		Subclass string `json:"subclass"`
	}

	TaskCustomFields struct {
		Name  string      `json:"name"`
		Value interface{} `json:"value"`
	}

	TaskRequirements struct {
		DNS string `json:"dns"`
	}

	CreateTaskRequest struct {
		CustomFields []TaskCustomFields `json:"custom_fields"`
		Description  string             `json:"description"`
		Owner        string             `json:"owner"`
		Priority     TaskPriority       `json:"priority"`
		Type         string             `json:"type"`
		Requirements TaskRequirements   `json:"requirements"`
	}

	StartTaskRequest struct {
		ID []int `json:"id"`
	}

	StartTaskResponse struct {
		Status  string `json:"status"`
		Message string `json:"message"`
		ID      int    `json:"id"`
	}
)
