package secnotify

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/security/impulse/models"
)

type SecurityIssueType string

const (
	Yes SecurityIssueType = "Yes"
	No  SecurityIssueType = "No"
)

type SecuritySeverityType string

const (
	Blocker       SecuritySeverityType = "6"
	Critical      SecuritySeverityType = "5"
	High          SecuritySeverityType = "4"
	Medium        SecuritySeverityType = "3"
	Low           SecuritySeverityType = "2"
	Informational SecuritySeverityType = "1"
	Unknown       SecuritySeverityType = "0"
)

var SeverityTrackerMap = map[models.SeverityType]SecuritySeverityType{
	models.Blocker:  High,
	models.Critical: Medium,
	models.Medium:   Low,
	models.Low:      Informational,
	models.Info:     Informational,
}

type (
	API interface {
		CreateTicket(ctx context.Context, templateID string, templateParameters map[string]interface{},
			issueParameters CreateTicketIssueParameters) (string, error)
		SetTVMClient(tvmClient tvm.Client)
	}

	Options struct {
		DstTvmID tvm.ClientID
		Endpoint string
		Token    string
	}

	CreateTicketIssueParameters struct {
		CreatedBy        string               `json:"createdBy"`
		Queue            string               `json:"queue"`
		Summary          string               `json:"summary"`
		Tags             []string             `json:"tags"`
		Assignee         string               `json:"assignee,omitempty"`
		Followers        []string             `json:"followers"`
		Security         SecurityIssueType    `json:"security"`
		SecuritySeverity SecuritySeverityType `json:"securitySeverity"`
	}

	CreateTicketDTORequest struct {
		TemplateID         string                      `json:"template_id"`
		TemplateParameters map[string]interface{}      `json:"template_parameters"`
		IssueParameters    CreateTicketIssueParameters `json:"issue_parameters"`
	}

	CreateTicketDTOResponse struct {
		Message  string `json:"message"`
		IssueKey string `json:"issue_key"`
	}
)
