package secnotify

import (
	"context"

	"github.com/go-resty/resty/v2"
	"golang.org/x/xerrors"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

type apiImpl struct {
	Client    *resty.Client
	TVMClient tvm.Client
	DstTvmID  tvm.ClientID
}

func New(opts *Options) *apiImpl {
	httpc := resty.New().
		SetHeader("Content-Type", "application/json; charset=utf-8").
		SetHeader("Authorization", opts.Token).
		SetBaseURL(opts.Endpoint)

	return &apiImpl{
		Client:   httpc,
		DstTvmID: opts.DstTvmID,
	}
}

func (api *apiImpl) SetTVMClient(tvmClient tvm.Client) {
	api.TVMClient = tvmClient
}

func (api *apiImpl) CreateTicket(ctx context.Context, templateID string, templateParameters map[string]interface{},
	issueParameters CreateTicketIssueParameters) (string, error) {
	ticket := ""
	var err error
	if api.TVMClient != nil {
		ticket, err = api.TVMClient.GetServiceTicketForID(ctx, api.DstTvmID)
		if err != nil {
			return "", err
		}
	}

	body := CreateTicketDTORequest{
		TemplateID:         templateID,
		TemplateParameters: templateParameters,
		IssueParameters:    issueParameters,
	}
	resp := CreateTicketDTOResponse{}
	httpResp, err := api.Client.R().
		SetHeader("X-Ya-Service-Ticket", ticket).
		SetResult(&resp).
		SetBody(&body).
		Post("/tracker/issue")
	if err != nil {
		return "", err
	}
	if !httpResp.IsSuccess() {
		return "", xerrors.Errorf("Secnotify: wrong status code for /tracker/issue %s", httpResp.Status())
	}

	return resp.IssueKey, nil
}
