package codeqldb

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	Create(ctx context.Context, codeQLDatabase *models.CodeQLDatabase) (*models.CodeQLDatabase, error)
	Update(ctx context.Context, codeQLDatabase *models.CodeQLDatabase) error
	Get(ctx context.Context, projectID int, language string, tag string) (*models.CodeQLDatabase, error)
	Delete(ctx context.Context, codeQLDatabase models.CodeQLDatabase) error
	ListTags(ctx context.Context, projectID int, language string) ([]string, error)
	GetByMdsURL(ctx context.Context, mdsURL string) (*models.CodeQLDatabase, error)
	CreateBuildTask(ctx context.Context, task *models.CodeQLBuildTask) (*models.CodeQLBuildTask, error)
	GetOldestBuildTasks(ctx context.Context, timestamp int64, count int) ([]*models.CodeQLBuildOldestTask, error)
}
