package cron

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	Create(ctx context.Context, cron *models.Cron) (int, error)
	List(ctx context.Context, organizationID, projectID int) ([]*models.CronResponseDTO, error)
	GetByID(ctx context.Context, organizationID, projectID, id int) (*models.Cron, error)
	Update(ctx context.Context, cron *models.Cron) error
	DeleteByID(ctx context.Context, organizationID, projectID, id int) error
	UpdateRunningState(ctx context.Context, organizationID, projectID, id int, isRunning bool) error
	ListAll(ctx context.Context) ([]*models.Cron, error)
	UpdateNextTime(ctx context.Context, organizationID, projectID, id int, nextTime int64) error
}
