package idm

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	Create(ctx context.Context, user *models.IdmUser) (*models.IdmUser, error)
	GetByLogin(ctx context.Context, login string) (*models.IdmUser, error)
	RemoveByLogin(ctx context.Context, login string) error
	AddUserRole(ctx context.Context, role *models.IdmUserRole) error
	RemoveUserRoleByLogin(ctx context.Context, login string, role *models.IdmRoleDTO) error
	ListUserRolesByLogin(ctx context.Context, login string) ([]*models.IdmUserRole, error)
	ListRoles(ctx context.Context) ([]*models.IdmUserRole, error)
	ListUsers(ctx context.Context) ([]*models.IdmUser, error)
}
