package organization

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	Create(ctx context.Context, org *models.Organization) (models.Organization, error)
	Update(ctx context.Context, org *models.Organization) error
	GetByID(ctx context.Context, id int) (*models.Organization, error)
	GetBySlug(ctx context.Context, slug string) (*models.Organization, error)
	List(ctx context.Context) ([]*models.OrganizationInfo, error)
	DeleteByID(ctx context.Context, id int) error
	GetSummaryStatisticsByID(ctx context.Context, id int) (*models.OrganizationStatistics, error)
}
