package project

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	Create(ctx context.Context, project *models.Project) (models.Project, error)
	Update(ctx context.Context, project *models.Project) error
	GetByID(ctx context.Context, id int) (*models.Project, error)
	GetBySlug(ctx context.Context, slug string) (*models.Project, error)
	GetByOrganizationIDAndProjectID(ctx context.Context, organizationID int, projectID int) (*models.Project, error)
	ListByOrganizationID(ctx context.Context, organizationID int) ([]*models.ProjectInfo, error)
	ListWithEnabledNotifications(ctx context.Context) ([]*models.ProjectInfo, error)
	DeleteByID(ctx context.Context, id int) error
	ListTags(ctx context.Context) ([]string, error)
	GetStatisticsByID(ctx context.Context, id int) (*models.ProjectStatistics, error)
}
