package scan

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	GetByID(ctx context.Context, id int) (*models.Scan, error)
	GetByProjectIDAndScanTypeName(ctx context.Context, projectID int, scanTypeName string) (*models.Scan, error)
	CreateNew(ctx context.Context, project *models.Project, scanType *models.ScanType) (*models.Scan, error)
	DeleteByID(ctx context.Context, id int) error
	GetLastScanInstance(ctx context.Context, scan *models.Scan) (*models.ScanInstance, error)
	ListByProjectID(ctx context.Context, projectID int) ([]*models.Scan, error)
}
