package scaninstance

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	GetByID(ctx context.Context, id int) (*models.ScanInstance, error)
	Create(ctx context.Context, scanInstance *models.ScanInstance) (*models.ScanInstance, error)
	UpdateLastScanInstance(ctx context.Context, scanInstance *models.ScanInstance) error
	InsertVulnerabilities2ScanInstance(ctx context.Context, scanInstance *models.ScanInstance,
		vulnerabilities []*models.Vulnerability) ([]*models.Vulnerability2ScanInstance, error)
	ListByTaskID(ctx context.Context, taskID string) ([]*models.ScanInstance, error)
	ListByScanID(ctx context.Context, scanID int) ([]*models.ScanInstance, error)
	GetStatisticsByID(ctx context.Context, id int) (*models.ScanInstanceStatistics, error)
	GetSummaryStatisticsFromScanInstances(ctx context.Context,
		scanInstances []*models.ScanInstance) (*models.ScanInstanceStatistics, error)
	GetLastScanInstancesByOrganizationID(ctx context.Context, organizationID int) ([]*models.ScanInstance,
		error)
}
