package vulnerabilitycategory

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	ListByScanType(ctx context.Context, scanTypeID int) ([]*models.VulnerabilityCategory, error)
	Insert(ctx context.Context, scanTypeID int, category string) (int, error)
	ListByScanInstance(ctx context.Context, scanInstance models.ScanInstance) ([]*models.VulnerabilityCategory, error)
	GetStatisticsByScanInstanceIDAndCategoryID(ctx context.Context, scanInstanceID int,
		categoryID int) (*models.VulnerabilityCategoryStatistics, error)
}
