package workflow

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Repository interface {
	Update(ctx context.Context, s *models.Workflow) (int64, error)
	UpdateWorkflowScanTypes(ctx context.Context, workflowID string, scanTypes []int) error
	Get(ctx context.Context, workflowID string) (*models.Workflow, error)
	ListWorkflows(ctx context.Context) ([]*models.Workflow, error)
	ListWorkflowScanTypeTitles(ctx context.Context, workflowID string) ([]*models.Workflow2ScanTypeTitle, error)
	ListWorkflowScanTypes(ctx context.Context, workflowID string) ([]*models.Workflow2ScanType, error)
}
