package config

import (
	"fmt"
	"strings"
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/security/impulse/api/internal/db"
	"a.yandex-team.ru/security/impulse/pkg/queue"
)

type (
	Config struct {
		UpstreamURL   string
		DBConn        string
		DBPassword    string
		DBRetries     int
		SqsEndpoint   string
		SqsAccount    string
		SqsRetries    int
		SqsOAuthToken string
		HTTPPort      uint32
		IdmTvmSrcID   tvm.ClientID
		UseAuth       bool
		Debug         bool
	}
)

func (c *Config) QueueConfig(tvmClient tvm.Client) *queue.Options {
	return &queue.Options{
		Endpoint:   c.SqsEndpoint,
		Account:    c.SqsAccount,
		MaxRetries: c.SqsRetries,
		AuthType:   queue.AuthOAuth,
		OAuthToken: c.SqsOAuthToken,
	}
}

func (c *Config) DBConfig() *db.Options {
	return &db.Options{
		DSN:             c.DBConn,
		Password:        c.DBPassword,
		QueryRetries:    c.DBRetries,
		MaxOpenConns:    10,
		MaxIdleConns:    2,
		ConnMaxLifetime: time.Hour,
	}
}

func (c *Config) TasksQueueURL() string {
	return fmt.Sprintf("%s/%s/%s",
		strings.TrimRight(c.SqsEndpoint, "/"),
		c.SqsAccount,
		"tasks",
	)
}
