package user

import (
	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/impulse/api/internal/user"
	"a.yandex-team.ru/security/impulse/api/internal/utils"
	"a.yandex-team.ru/security/impulse/api/scan-api/internal/infra"
)

type Controller struct {
	*infra.Infra
}

func (c *Controller) BuildRoute(g *echo.Group) error {
	g.GET("/user", c.userinfo)

	return nil
}

func (c *Controller) userinfo(e echo.Context) error {
	response, err := user.UserInfo(e)
	if err != nil {
		return utils.APIError(e, err)
	}

	return utils.APIOk(e, response)
}
