package infra

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
	"a.yandex-team.ru/security/impulse/api/internal/db"
	"a.yandex-team.ru/security/impulse/api/scan-api/internal/config"
	"a.yandex-team.ru/security/impulse/pkg/queue"
)

type Infra struct {
	ctx      context.Context
	CFG      config.Config
	DB       *db.DB
	Queue    queue.Queue
	TVM      *tvmtool.Client
	BlackBox blackbox.Client
}

func New(cfg config.Config) *Infra {
	return &Infra{
		ctx: context.Background(),
		CFG: cfg,
	}
}

func (c *Infra) Start() (err error) {
	if c.CFG.UseAuth {
		c.TVM, err = tvmtool.NewAnyClient()
		if err != nil {
			return
		}

		c.BlackBox, err = httpbb.NewIntranet(httpbb.WithTVM(c.TVM))
		if err != nil {
			return err
		}
	}

	c.Queue, err = queue.New(c.CFG.QueueConfig(c.TVM))
	if err != nil {
		return
	}

	c.DB, err = db.New(c.CFG.DBConfig())
	if err != nil {
		return
	}
	err = c.DB.InitSchema()
	if err != nil {
		return
	}

	return
}

func (c *Infra) Done() (err error) {

	return
}
