package server

import (
	"a.yandex-team.ru/security/impulse/api/scan-api/internal/controllers"
	"a.yandex-team.ru/security/impulse/api/scan-api/internal/controllers/cron"
	"a.yandex-team.ru/security/impulse/api/scan-api/internal/controllers/idm"
	"a.yandex-team.ru/security/impulse/api/scan-api/internal/controllers/task"
	"a.yandex-team.ru/security/impulse/api/scan-api/internal/controllers/user"
	"a.yandex-team.ru/security/impulse/api/scan-api/internal/infra"
)

type serverControllers struct {
	Task controllers.Controller
	Idm  controllers.Controller
	Cron controllers.Controller
	User controllers.Controller
}

func newControllers(infra *infra.Infra) serverControllers {
	return serverControllers{
		Task: &task.Controller{Infra: infra},
		Idm:  &idm.Controller{Infra: infra},
		Cron: &cron.Controller{Infra: infra},
		User: &user.Controller{Infra: infra},
	}
}
