package config

import (
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/security/impulse/api/internal/db"
	"a.yandex-team.ru/security/impulse/api/internal/secnotify"
)

type (
	Config struct {
		UpstreamURL       string
		DBConn            string
		DBPassword        string
		DBRetries         int
		HTTPPort          uint32
		UseAuth           bool
		Debug             bool
		SecNofityURL      string
		SecNotifyDstTvmID tvm.ClientID
		SecNofityToken    string
	}
)

func (c *Config) DBConfig() *db.Options {
	return &db.Options{
		DSN:             c.DBConn,
		Password:        c.DBPassword,
		QueryRetries:    c.DBRetries,
		MaxOpenConns:    10,
		MaxIdleConns:    2,
		ConnMaxLifetime: time.Hour,
	}
}

func (c *Config) SecNotifyConfig() *secnotify.Options {
	return &secnotify.Options{
		Endpoint: c.SecNofityURL,
		Token:    c.SecNofityToken,
		DstTvmID: c.SecNotifyDstTvmID,
	}
}
