package scantype

import (
	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/impulse/api/internal/utils"
	_scanTypeRepo "a.yandex-team.ru/security/impulse/api/repositories/scantype"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/infra"
	_scanTypeUsecase "a.yandex-team.ru/security/impulse/api/usecases/scantype"
	"a.yandex-team.ru/security/impulse/models"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

type Controller struct {
	*infra.Infra
	scanTypeUsecase _scanTypeUsecase.Usecase
}

func (c *Controller) BuildRoute(g *echo.Group) error {
	scanTypeRepo := _scanTypeRepo.NewScanTypeRepository(c.DB)
	c.scanTypeUsecase = _scanTypeUsecase.NewScanTypeUsecase(scanTypeRepo)

	g.GET("/scanTypes", c.getScanTypes)

	return nil
}

func (c *Controller) getScanTypes(e echo.Context) error {
	simplelog.Info(e.Request().Method + " " + e.Path())

	scanTypes, err := c.scanTypeUsecase.List(e.Request().Context())
	if err != nil {
		return utils.APIError(e, err)
	}

	var scanTypesResponse []*models.ScanTypeResponseDTO
	for _, scanType := range scanTypes {
		parameters, err := c.scanTypeUsecase.GetScanTypeParameters(e.Request().Context(), scanType.ID)
		if err != nil {
			return utils.APIError(e, err)
		}
		scanTypesResponse = append(scanTypesResponse, &models.ScanTypeResponseDTO{ScanType: *scanType, Parameters: parameters})
	}

	return utils.APIOk(e, scanTypesResponse)
}
