package infra

import (
	"time"

	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
	"a.yandex-team.ru/security/impulse/api/internal/db"
	"a.yandex-team.ru/security/impulse/api/internal/secnotify"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/config"
)

type Infra struct {
	CFG       config.Config
	DB        *db.DB
	TVM       *tvmtool.Client
	BlackBox  blackbox.Client
	SecNotify secnotify.API
}

func New(cfg config.Config) *Infra {
	return &Infra{
		CFG: cfg,
	}
}

func (c *Infra) Start() (err error) {
	c.SecNotify = secnotify.New(c.CFG.SecNotifyConfig())
	if c.CFG.UseAuth {
		c.TVM, err = tvmtool.NewAnyClient()
		if err != nil {
			return
		}
		c.SecNotify.SetTVMClient(c.TVM)
		c.BlackBox, err = httpbb.NewIntranet(httpbb.WithTVM(c.TVM), httpbb.WithRetries(5), httpbb.WithTimeout(time.Second))
		if err != nil {
			return err
		}
	}

	c.DB, err = db.New(c.CFG.DBConfig())
	if err != nil {
		return err
	}
	err = c.DB.InitSchema()
	if err != nil {
		return err
	}
	return nil
}

func (c *Infra) Done() (err error) {
	return nil
}
