package server

import (
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/controllers"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/controllers/organization"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/controllers/project"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/controllers/scan"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/controllers/scantype"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/controllers/task"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/controllers/vuln"
	"a.yandex-team.ru/security/impulse/api/storage-api/internal/infra"
)

type serverControllers struct {
	VulnController         controllers.Controller
	OrganizationController controllers.Controller
	ProjectController      controllers.Controller
	TaskController         controllers.Controller
	ScanController         controllers.Controller
	ScanTypeController     controllers.Controller
}

func newControllers(infra *infra.Infra) serverControllers {
	return serverControllers{
		VulnController:         &vuln.Controller{Infra: infra},
		OrganizationController: &organization.Controller{Infra: infra},
		ProjectController:      &project.Controller{Infra: infra},
		TaskController:         &task.Controller{Infra: infra},
		ScanController:         &scan.Controller{Infra: infra},
		ScanTypeController:     &scantype.Controller{Infra: infra},
	}
}
