package codeqldb

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	Save(ctx context.Context, project models.Project, lang string, tag string,
		mdsURL string, revision string) (*models.CodeQLDatabase, error)
	Get(ctx context.Context, project models.Project, lang string, tag string) (*models.CodeQLDatabase, error)
	Delete(ctx context.Context, codeQLDatabase models.CodeQLDatabase) error
	ListTags(ctx context.Context, project models.Project, lang string) ([]string, error)
	GetByMDS(ctx context.Context, mdsURL string) (*models.CodeQLDatabase, error)
	CreateBuildTask(ctx context.Context, task *models.CodeQLBuildTask) (*models.CodeQLBuildTask, error)
	GetOldestBuildTasks(ctx context.Context, timestamp int64, count int) ([]*models.CodeQLBuildOldestTask, error)
}
