package project

import (
	"context"

	"a.yandex-team.ru/security/impulse/api/repositories/cron"
	"a.yandex-team.ru/security/impulse/models"
)

type cronUsecase struct {
	repo cron.Repository
}

func NewCronUsecase(repo cron.Repository) Usecase {
	return &cronUsecase{repo: repo}
}

func (c cronUsecase) Create(ctx context.Context, cron *models.Cron) (int, error) {
	return c.repo.Create(ctx, cron)
}

func (c cronUsecase) List(ctx context.Context, organizationID, projectID int) ([]*models.CronResponseDTO, error) {
	return c.repo.List(ctx, organizationID, projectID)
}

func (c cronUsecase) ListAll(ctx context.Context) ([]*models.Cron, error) {
	return c.repo.ListAll(ctx)
}

func (c cronUsecase) GetByID(ctx context.Context, organizationID, projectID, id int) (*models.Cron, error) {
	return c.repo.GetByID(ctx, organizationID, projectID, id)
}

func (c cronUsecase) Update(ctx context.Context, cron *models.Cron) error {
	return c.repo.Update(ctx, cron)
}

func (c cronUsecase) DeleteByID(ctx context.Context, organizationID, projectID, id int) error {
	return c.repo.DeleteByID(ctx, organizationID, projectID, id)
}

func (c cronUsecase) UpdateRunningState(ctx context.Context, organizationID, projectID, id int, isRunning bool) error {
	return c.repo.UpdateRunningState(ctx, organizationID, projectID, id, isRunning)
}

func (c cronUsecase) UpdateNextTime(ctx context.Context, organizationID, projectID, id int, nextTime int64) error {
	return c.repo.UpdateNextTime(ctx, organizationID, projectID, id, nextTime)
}
