package idm

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	GetByLogin(ctx context.Context, login string) (*models.IdmUser, error)
	GetOrCreateByLogin(ctx context.Context, login string, isTvmApp bool) (*models.IdmUser, error)
	RemoveByLogin(ctx context.Context, login string) error
	IsValidRole(role string) bool
	AddUserRole(ctx context.Context, role *models.IdmUserRole) error
	RemoveUserRoleByLogin(ctx context.Context, login string, role *models.IdmRoleDTO) error
	ListUserRolesByLogin(ctx context.Context, login string) ([]*models.IdmUserRole, error)
	ListRoles(ctx context.Context) ([]*models.IdmUserRole, error)
	ListUsers(ctx context.Context) ([]*models.IdmUser, error)
}
