package organization

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	Create(ctx context.Context, org *models.OrganizationRequestDTO) (models.Organization, error)
	Update(ctx context.Context, org *models.Organization) error
	GetByID(ctx context.Context, id int) (*models.Organization, error)
	GetIDBySlug(ctx context.Context, slug string) (int, error)
	List(ctx context.Context) ([]*models.OrganizationInfo, error)
	DeleteByID(ctx context.Context, id int) error
	GetStatisticsByID(ctx context.Context, id int) (*models.OrganizationStatistics, error)
}
