package project

import (
	"context"

	"a.yandex-team.ru/security/impulse/api/repositories/project"
	"a.yandex-team.ru/security/impulse/api/repositories/scaninstance"
	_scanInstanceUsecase "a.yandex-team.ru/security/impulse/api/usecases/scaninstance"
	"a.yandex-team.ru/security/impulse/models"
)

type projectUsecase struct {
	projectRepo         project.Repository
	scanInstanceRepo    scaninstance.Repository
	scanInstanceUsecase _scanInstanceUsecase.Usecase
}

func (p projectUsecase) Create(ctx context.Context, project *models.Project) (models.Project, error) {
	return p.projectRepo.Create(ctx, project)
}

func (p projectUsecase) Update(ctx context.Context, project *models.Project) error {
	return p.projectRepo.Update(ctx, project)
}

func (p projectUsecase) GetByID(ctx context.Context, id int) (*models.Project, error) {
	return p.projectRepo.GetByID(ctx, id)
}

func (p projectUsecase) GetIDBySlug(ctx context.Context, slug string) (int, error) {
	project, err := p.projectRepo.GetBySlug(ctx, slug)
	if err != nil {
		return 0, err
	}
	return project.ID, nil
}

func (p projectUsecase) GetStatisticsByID(ctx context.Context, id int) (*models.ProjectStatistics, error) {
	projectStatistics, err := p.projectRepo.GetStatisticsByID(ctx, id)
	if err != nil {
		return nil, err
	}
	return projectStatistics, nil
}

func (p projectUsecase) GetByOrganizationIDAndProjectID(ctx context.Context, organizationID int, projectID int) (*models.Project, error) {
	return p.projectRepo.GetByOrganizationIDAndProjectID(ctx, organizationID, projectID)
}

func (p projectUsecase) ListByOrganizationID(ctx context.Context, organizationID int) ([]*models.ProjectInfo, error) {
	return p.projectRepo.ListByOrganizationID(ctx, organizationID)
}

func (p projectUsecase) ListWithEnabledNotifications(ctx context.Context) ([]*models.ProjectInfo, error) {
	return p.projectRepo.ListWithEnabledNotifications(ctx)
}

func (p projectUsecase) DeleteByID(ctx context.Context, id int) error {
	return p.projectRepo.DeleteByID(ctx, id)
}

func (p projectUsecase) ListTags(ctx context.Context) ([]string, error) {
	return p.projectRepo.ListTags(ctx)
}

func NewProjectUsecase(projectRepo project.Repository, scanInstanceRepo scaninstance.Repository,
	scanInstanceUsecase _scanInstanceUsecase.Usecase) Usecase {
	return &projectUsecase{
		projectRepo:         projectRepo,
		scanInstanceRepo:    scanInstanceRepo,
		scanInstanceUsecase: scanInstanceUsecase,
	}
}
